/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics;

import javax.annotation.Nonnull;

public class Paint {
    private static final Paint sInstance = new Paint();
    private static final int STYLE_MASK = 3;
    private int mColor;
    private int mFlags;
    private float mStrokeWidth;
    private float mFeatherRadius;

    public Paint() {
        this.reset();
    }

    public void reset() {
        this.mColor = -1;
        this.mStrokeWidth = 1.0f;
        this.mFeatherRadius = 1.0f;
    }

    @Nonnull
    public static Paint take() {
        return sInstance;
    }

    public void setRGBA(int r, int g2, int b, int a) {
        this.mColor = a << 24 | r << 16 | g2 << 8 | b;
    }

    public void setRGB(int r, int g2, int b) {
        this.mColor = this.mColor & 0xFF000000 | r << 16 | g2 << 8 | b;
    }

    public void setColor(int color) {
        this.mColor = color;
    }

    public void setAlpha(int a) {
        this.mColor = this.mColor & 0xFFFFFF | a << 24;
    }

    public int getColor() {
        return this.mColor;
    }

    @Nonnull
    public Style getStyle() {
        return Style.values()[this.mFlags & 3];
    }

    public void setStyle(@Nonnull Style style) {
        this.mFlags = this.mFlags & 0xFFFFFFFC | style.ordinal();
    }

    public float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public void setStrokeWidth(float width) {
        this.mStrokeWidth = Math.max(0.0f, width);
    }

    public float getFeatherRadius() {
        return this.mFeatherRadius;
    }

    public void setFeatherRadius(float radius) {
        this.mFeatherRadius = Math.max(0.0f, radius);
    }

    public static enum Style {
        FILL,
        STROKE,
        FILL_AND_STROKE;

    }
}

